    clear all;
    close all;

%File details
    delimiterIn = ' ';
    headerLinesIn = 0;

    if(exist('PathName','var')==0); PathName = ''; end
    
    %r=[0:0.1:16] 
    %y = zeros(length(r),1);
    figure;
    hold on;
    %plot(r,y,'--k');
    
    
    n = 1;
    for i = 1:n
   
%Open the datafile
    FilterSpec = '.dat';

    DialogTitle = 'Select file with H/R data.';
    [posH_Datafile,PathName] = uigetfile(FilterSpec,DialogTitle,PathName);
    imp_Data = importdata([PathName,posH_Datafile],delimiterIn,headerLinesIn);
   
%Checks to see if datafiles are structures
    if(isstruct(imp_Data)); Data=imp_Data.data;
    else Data = imp_Data; end
   
%Plot Data    
    clear j
    clear k
    clear MR
    k = size(Data(:,1));
    k = k(1);
    for j = 1:k
        MR(j,1) = Data(j,1);
        MR(j,2) = (Data(j,2) - Data(1,2))./Data(1,2);
    end
    %plot(MR(:,1),MR(:,2));
    plot(Data(:,1),Data(:,2)-min(Data(:,2)));
    
    
    end
    
    
    xlabel('B (T)','fontsize',18,'fontname','times');
    ylabel('R_{xx} (\Omega)','fontsize',18,'fontname','times');   
    set(gcf,'color','w'); 
    set(findall(gca, 'Type', 'Line'),'LineWidth',2);
    set(gcf, 'Position', [50, 50, 600, 550])
    set(gca,'fontsize',18,'fontname','times');
    box on;
    hold off;
        
    